package nemosofts.notes.app.activity;

import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.nemosofts.LauncherListener;
import androidx.nemosofts.LauncherTask;
import androidx.nemosofts.theme.ColorUtils;

import nemosofts.notes.app.BuildConfig;
import nemosofts.notes.app.R;
import nemosofts.notes.app.callback.Callback;


public class LauncherActivity extends AppCompatActivity implements LauncherListener {

    private ProgressBar pb;
    Application application;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_launcher);
        hideNavigationBarStatusBars();

        pb = findViewById(R.id.pb_splash);

        findViewById(R.id.rl_splash).setBackgroundColor(ColorUtils.colorBg(this));

        TextView appName = findViewById(R.id.tv_app_name);
        appName.setTextColor(ColorUtils.colorTitle(this));

        TextView appVersion = findViewById(R.id.tv_version);
        appVersion.setTextColor(ColorUtils.colorTitleSub(this));
        String version = getString(R.string.version) + " " + BuildConfig.VERSION_NAME;
        appVersion.setText(version);

        new LauncherTask(this, this).execute();
    }

    private void loadSettings() {
        application = getApplication();
        ((MyApplication) application).loadAd(LauncherActivity.this);
        openMainActivity();
    }

    private void openMainActivity() {
        pb.setVisibility(View.VISIBLE);
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (isFinishing()){
                return;
            }
            Intent intent;
            if (!((MyApplication) application).getAppOpenAdManager().isAdAvailable()
                    || (Callback.getIsAppOpenAdShown()
                    && !((MyApplication) application).getAppOpenAdManager().getIsShowingAd())) {
                intent = new Intent(LauncherActivity.this, MainActivity.class);
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();
            } else if(((MyApplication) application).getAppOpenAdManager().isAdAvailable()
                    && Boolean.TRUE.equals(!((MyApplication) application).getAppOpenAdManager().getIsShowingAd())) {
                ((MyApplication) application).getAppOpenAdManager().showAdIfAvailable(LauncherActivity.this);
            }
        }, 5500);
    }

    @Override
    public void onStartPairing() {
        pb.setVisibility(View.VISIBLE);
    }

    @Override
    public void onConnected() {
        pb.setVisibility(View.GONE);
        loadSettings();
    }

    @Override
    public void onError(String message) {
        pb.setVisibility(View.GONE);
        if (message == null || message.isEmpty()){
            errorDialog(getString(R.string.err_unauthorized_access), message);
            return;
        }
        errorDialog(getString(R.string.err_server), getString(R.string.err_server_not_connected));
    }

    private void errorDialog(String title, String message) {
        final AlertDialog.Builder alertDialog = new AlertDialog.Builder(LauncherActivity.this, R.style.dialogTheme);
        alertDialog.setTitle(title);
        alertDialog.setMessage(message);
        alertDialog.setCancelable(false);
        if (title.equals(getString(R.string.err_internet_not_connected)) || title.equals(getString(R.string.err_server_not_connected))) {
            alertDialog.setNegativeButton(getString(R.string.retry), (dialog, which) -> new LauncherTask(this, this).execute());
        }
        alertDialog.setPositiveButton(getString(R.string.exit), (dialog, which) -> finish());
        alertDialog.show();
    }

    public void hideNavigationBarStatusBars() {
        try {
            Window window = getWindow();
            View decorView = window.getDecorView();

            // Allow content to extend behind system bars
            WindowCompat.setDecorFitsSystemWindows(window, false);

            // Use compatible insets controller
            WindowInsetsControllerCompat controller = new WindowInsetsControllerCompat(window, decorView);

            // Hide status and navigation bars
            controller.hide(WindowInsetsCompat.Type.statusBars() | WindowInsetsCompat.Type.navigationBars());

            // Enable immersive sticky behavior (swipe to temporarily show bars)
            controller.setSystemBarsBehavior(
                    WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE
            );
        } catch (Exception e) {
            Log.e("LauncherActivity", "Failed to hide Navigation Bar & Status Bar", e);
        }
    }
}